/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32h6xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32h6xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32h6xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/
void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV1);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV2);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void GPIO_Toggle(void)
{
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN);
  
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  GPIO_InitStruct.Alternate = GPIO_AF0;
  GPIO_InitStruct.Pin = GPIO_PIN_3;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_PUPDR_Pullup;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_Init(GPIOC,&GPIO_InitStruct);
	GPIO_InitStruct.Pin = GPIO_PIN_4;
	GPIO_Init(GPIOC,&GPIO_InitStruct);
}

void COMP1_PIN(void)
{
	/* COMP1_P1 -> PC0(Analog)  COMP1_P2 -> PB6(Analog)     	COMP1_P3 -> PB4(Analog) 
	   COMP1_N1 -> PC1(Analog)  COMP1_N2 -> PB7(Analog)       COMP1_N3 -> PB5(Analog) 

	  COMP1_O -> PA4(AF2)		       */
	GPIO_InitTypeDef GPIO_InitStruct = {0};
	/*--------COMP1----------*/
	GPIO_InitStruct.Mode = GPIO_MODER_MODER_Analog;
	GPIO_InitStruct.Pull = GPIO_PUPDR_Floating;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_InitStruct.Alternate = GPIO_AF0;
  //COMP1_P1 -> PC0
	GPIO_InitStruct.Pin  = GPIO_PIN_0;
	GPIO_Init(GPIOC, &GPIO_InitStruct);
  //COMP1_N1 -> PC1
	GPIO_InitStruct.Pin  = GPIO_PIN_1;
	GPIO_Init(GPIOC, &GPIO_InitStruct);
  //COMP1_O -> PA4
	GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
	GPIO_InitStruct.Alternate   =  GPIO_AF2;
	GPIO_InitStruct.Pin  = GPIO_PIN_4;
	GPIO_Init(GPIOA, &GPIO_InitStruct);
}

void COMP1_CONFIG(void)
{
	/*--------CMP1 Initial Structure-------*/
	CMP_InitTypeDef CMP_InitStruct = {0};
	CMP_InitStruct.Pol  	  = CMP_CxCR_POL_Positive;
	CMP_InitStruct.OFLT 	  = CMP_CxCR_OFLT_DIV1;
	CMP_InitStruct.Rhyst	  = CMP_CxCR_RHYST_0mV;
	CMP_InitStruct.Fhyst	  = CMP_CxCR_FHYST_0mV;
  CMP_InitStruct.CR1_SRN  = DISABLE;
	CMP_InitStruct.INM_Sel  = CMP_INM_SEL_N1;   
	CMP_InitStruct.INP_Sel  = CMP_INP_SEL_P1;	
	CMP_Init(COMP1, &CMP_InitStruct);
	CMP_Enable(COMP1);    //Enable COMP1 
}


int main(void)
{
  SystemClock_Config();
	
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN |RCC_AHBENR_IOPAEN |RCC_AHBENR_IOPCEN|RCC_AHBENR_IOPDEN);
	
	RCC_Enable_APB2Clock( RCC_APB2ENR_SYSCFGEN); 

  COMP1_PIN();
  COMP1_CONFIG();    

  while(1)
  {
  }
}
