/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32h6xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32h6xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32h6xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/

void Delay_us( uint32_t us )
{
	uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000;
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_10x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void GPIO_Toggle(void)
{
  RCC_Enable_AHBClock(RCC_AHBENR_IOPAEN|RCC_AHBENR_IOPBEN|RCC_AHBENR_IOPCEN|RCC_AHBENR_IOPDEN);  
  
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_PUPDR_Pullup;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_InitStruct.Alternate = GPIO_AF0; 
  GPIO_InitStruct.Pin = GPIO_PIN_5;
  GPIO_Init(GPIOA,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_6;
  GPIO_Init(GPIOA,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_7;
  GPIO_Init(GPIOA,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_4;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_5;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_6;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_7;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
}

void TIM2_GPIO_Config(void)
{
  GPIO_Set_PinMode(GPIOC, GPIO_PIN_0, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOC, GPIO_PIN_0, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOC, GPIO_PIN_0, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOC, GPIO_PIN_0, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOC, GPIO_PIN_0, GPIO_AF2 );

  GPIO_Set_PinMode(GPIOB, GPIO_PIN_1, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_1, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_1, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_1, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_1, GPIO_AF5 );

  GPIO_Set_PinMode(GPIOB, GPIO_PIN_2, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_2, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_2, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_2, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_2, GPIO_AF5 );
}

void TIM2_Encoder_Config(void)
{
  //Set base
  TIM_Set_CounterMode(TIM2,TIM_COUNTERMODE_UP);  
  TIM_Set_AutoReload(TIM2,3);
  TIM_Set_Prescaler(TIM2,0);  
  
  //Set Slave mode
  TIM_Set_IC_ActiveInput(TIM2,TIM_CHANNEL_CH1,TIM_ACTIVEINPUT_DIRECTTI);//CC1S=1
  TIM_Set_IC_ActiveInput(TIM2,TIM_CHANNEL_CH2,TIM_ACTIVEINPUT_DIRECTTI);//CC2S=1
  TIM_Set_IC_Polarity(TIM2,TIM_CHANNEL_CH1,TIM_IC_POLARITY_RISING);//CC1P  
  TIM_Set_IC_Polarity(TIM2,TIM_CHANNEL_CH2,TIM_IC_POLARITY_RISING);//CC2P
  TIM_Set_SlaveMode(TIM2,TIM_ENCODERMODE_X2_TI1);
    
  //Set Interrupt
  TIM_Enable_IT(TIM2,TIM_DIER_UIE);  
  NVIC_EnableIRQ(TIM2_IRQn);  
  TIM_Enable_CEN(TIM2); 
}


void UART2_Init_Async( uint32_t baudrate )
{
	RCC_Enable_APB1Clock(RCC_APB1ENR_UART2EN);
	
	GPIO_InitTypeDef GPIO_InitStruct  = {0};
	UART_InitTypeDef UART_InitStruct = {0};
	UART_InitStruct.BaudRate             = baudrate;
	UART_InitStruct.DataWidth            = UART_DATAWIDTH_8B;
	UART_InitStruct.Parity               = UART_PARITY_NONE;
	UART_InitStruct.StopBits             = UART_STOPBITS_1;
	UART_InitStruct.TransferDirection    = UART_DIRECTION_TX_RX;
	UART_Init(UART2,&UART_InitStruct);

  //PD5  -> UART2_TX
	//PD4  -> UART2_RX
	GPIO_InitStruct.Alternate = GPIO_AF5;
	GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull      = GPIO_PUPDR_Pullup;
	GPIO_InitStruct.Speed     = GPIO_OSPEEDR_High;
	GPIO_InitStruct.Pin       = GPIO_PIN_4;
	GPIO_Init(GPIOD, &GPIO_InitStruct);
	GPIO_InitStruct.Pull      = GPIO_PUPDR_Floating;
	GPIO_InitStruct.Pin       = GPIO_PIN_5;
	GPIO_Init(GPIOD, &GPIO_InitStruct);

	UART_Enable(UART2);
}

void encoderio(void)
{
  if(TIM2->CNT==0)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_7);
  if(TIM2->CNT==1)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_6);
  if(TIM2->CNT==2)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_5);
  if(TIM2->CNT==3)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_4);
}

int main(void)
{
  SystemClock_Config();
  
  GPIO_Toggle();
  TIM2_GPIO_Config();
  RCC_Enable_APB1Clock(RCC_APB1ENR_TIM2EN); 
 
  UART2_Init_Async(115200);
  
  TIM2_Encoder_Config();
    
  while(1)
  {
    GPIO_Toggle_Pin(GPIOA,GPIO_PIN_6);
    Delay_us(3); 
    encoderio();                
    GPIO_Toggle_Pin(GPIOA,GPIO_PIN_7);
    Delay_us(3);
    encoderio();  
  }
}

