/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32h6xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32h6xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32h6xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/
/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/


void Delay_us( uint32_t us )
{
  uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000;
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV1);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void TIM2_GPIO_Config(void)
{ 
  /*
  TIM2:
  CH1 :PC0_AF2
  CH2 :PB6_AF2
  CH3 :PB4_AF2 
  CH4 :PB3_AF2 
  */ 
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN); 
  RCC_Enable_AHBClock(RCC_AHBENR_IOPCEN);   
  
  //CH1:PC0_AF2
  GPIO_Set_PinMode(GPIOC, GPIO_PIN_0, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOC, GPIO_PIN_0, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOC, GPIO_PIN_0, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOC, GPIO_PIN_0, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOC, GPIO_PIN_0, GPIO_AF2);

  //CH2:PB6_AF2
  GPIO_Set_PinMode(GPIOB, GPIO_PIN_6, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_6, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_6, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_6, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_6, GPIO_AF2);
 
  //CH3:PB4_AF2
  GPIO_Set_PinMode(GPIOB, GPIO_PIN_4, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_4, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_4, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_4, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_4, GPIO_AF2);
  
  //CH4:PB3_AF2
  GPIO_Set_PinMode(GPIOB, GPIO_PIN_3, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_3, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_3, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_3, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_3, GPIO_AF2);
}

void TIM8_GPIO_Config(void)
{ 
  /*
  TIM8:
  CH1  :PD3_AF1
  CH1N :PD0_AF5
  CH2  :PD2_AF5
  CH2N :PC7_AF5
  CH3  :PD1_AF5 
  CH3N :PC6_AF1
  CH4  :PC5_AF1 
  CH5  :PB1_AF1
  CH6  :PB2_AF1
  */ 
  
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN); 
  RCC_Enable_AHBClock(RCC_AHBENR_IOPCEN);
  RCC_Enable_AHBClock(RCC_AHBENR_IOPDEN);  
  
  
  GPIO_InitTypeDef        GPIO_InitStruct = {0};
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_PUPDR_Floating;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  
  GPIO_InitStruct.Alternate = GPIO_AF1;
  GPIO_InitStruct.Pin = GPIO_PIN_3;											//PD3(AF1)    TIM8CH1
  GPIO_Init(GPIOD,&GPIO_InitStruct);
  
  GPIO_InitStruct.Alternate = GPIO_AF5;
  GPIO_InitStruct.Pin = GPIO_PIN_0;											//PD0(AF5)    TIM8CH1N
  GPIO_Init(GPIOD,&GPIO_InitStruct);
	
	GPIO_InitStruct.Alternate = GPIO_AF5;
  GPIO_InitStruct.Pin = GPIO_PIN_2;											//PD2(AF5)    TIM8CH2
  GPIO_Init(GPIOD,&GPIO_InitStruct);
  
  GPIO_InitStruct.Alternate = GPIO_AF5;
  GPIO_InitStruct.Pin = GPIO_PIN_7;											//PC7(AF5)    TIM8CH2N
  GPIO_Init(GPIOC,&GPIO_InitStruct);
	
	GPIO_InitStruct.Alternate = GPIO_AF5;
  GPIO_InitStruct.Pin = GPIO_PIN_1;											//PD1(AF5)    TIM8CH3
  GPIO_Init(GPIOD,&GPIO_InitStruct);
  
  GPIO_InitStruct.Alternate = GPIO_AF1;
  GPIO_InitStruct.Pin = GPIO_PIN_6;											//PC6(AF1)    TIM8CH3N
  GPIO_Init(GPIOC,&GPIO_InitStruct);
	
	GPIO_InitStruct.Alternate = GPIO_AF1;
  GPIO_InitStruct.Pin = GPIO_PIN_5;											//PC5(AF1)    TIM8CH4
  GPIO_Init(GPIOC,&GPIO_InitStruct);
	
	GPIO_InitStruct.Alternate = GPIO_AF1;
  GPIO_InitStruct.Pin = GPIO_PIN_1;											//PB1(AF1)    TIM8CH5
  GPIO_Init(GPIOB,&GPIO_InitStruct);

	GPIO_InitStruct.Alternate = GPIO_AF1;
  GPIO_InitStruct.Pin = GPIO_PIN_2;											//PB2(AF1)    TIM8CH6
  GPIO_Init(GPIOB,&GPIO_InitStruct);
}

void TIM_initial(TIM_TypeDef *TIMx)
{
  RCC_Enable_APB2Clock(RCC_APB2ENR_TIM8EN);//TIM8 Clock EN 
  TIM8_GPIO_Config();
  
  TIM_Enable_MasterSlaveMode(TIM8);
  TIM_Set_ClockSource(TIM8,TIM_CLOCKSOURCE_INTERNAL);
  TIM_Set_TriggerOutput(TIM8,TIM_TRGO_ENABLE);
  
  //SET CNT BASE
  TIM_Set_Prescaler(TIMx, TIM8_Prescaler);
  TIM_Set_AutoReload(TIMx,(TIM8_ARR-1));
  TIM_Set_RepetitionCounter(TIMx,0);
 
 //CH1 / CH1N
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH1, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH1, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH1N, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH1(TIMx, TIM8_CCR);
  
  //CH2 / CH2N
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH2, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH2, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH2N, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH2(TIMx, TIM8_CCR);
  
  //CH3 / CH3N
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH3, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH3, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH3N, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH3(TIMx, TIM8_CCR);
  //CH4 / CH4N
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH4, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH4, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH4(TIMx, TIM8_CCR);
  //CH5
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH5, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH5, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH5(TIMx, TIM8_CCR);
  //CH6
  TIM_Set_OC_Mode(TIMx, TIM_CHANNEL_CH6, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIMx, TIM_CHANNEL_CH6, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH6(TIMx, TIM8_CCR);
   /* Set Deadtime */
  TIM_Set_ClockDivision(TIMx,TIM_CLOCKDIVISION_DIV1);
  
  /**********************************/
	/* Start output signal generation */
	/**********************************/
	/* Enable outputs OC1, OC1N, OC2, OC2N, OC3 and OC3N */
  TIM_Enable_CC_Channel(TIMx, 
                        TIM_CHANNEL_CH1|TIM_CHANNEL_CH1N|
                        TIM_CHANNEL_CH2|TIM_CHANNEL_CH2N|
                        TIM_CHANNEL_CH3|TIM_CHANNEL_CH3N|
                        TIM_CHANNEL_CH4|
                        TIM_CHANNEL_CH5|TIM_CHANNEL_CH6);  
  
  TIM_Enable_MOE(TIMx);

}

void TIM2_PWMout(void)
{
  RCC_Enable_APB1Clock(RCC_APB1ENR_TIM2EN);//TIM2 Clock EN  
  TIM2_GPIO_Config();
  
  //SET CNT BASE
  TIM_Set_Prescaler(TIM2, TIM2_Prescaler);
  TIM_Set_AutoReload(TIM2, (TIM2_ARR-1));
  TIM_Set_RepetitionCounter(TIM2,0); 

  MODIFY_REG(TIM2->TRGI,1,1); //Slave TIM SYN 
  
  TIM_Set_SlaveMode(TIM2,TIM_SMCR_SMS_TRIGGER);
  TIM_Set_TriggerInput(TIM2,TIM_SMCR_TS_ITR1);
  TIM_Set_GenerateEvent(TIM2, TIM_EGR_UG);
 
  //CH1 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH1, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH1, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH1(TIM2, TIM2_CCR);
  
  //CH2 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH2, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH2, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH2(TIM2, TIM2_CCR);
  
  //CH3 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH3, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH3, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH3(TIM2, TIM2_CCR);
  
  //CH4 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH4, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH4, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH4(TIM2, TIM2_CCR);
   
	/* Enable outputs OC1, OC2, OC3, OC4 */
  TIM_Enable_CC_Channel(TIM2, TIM_CHANNEL_CH1|TIM_CHANNEL_CH2|TIM_CHANNEL_CH3|TIM_CHANNEL_CH4); 
  
                   
  TIM_Enable_MOE(TIM2);
}

int main(void)
{
  SystemClock_Config();
  
  TIM2_PWMout();
  TIM_initial(TIM8);
  
  TIM_Set_GenerateEvent(TIM2, TIM_EGR_UG);
  TIM_Set_GenerateEvent(TIM8, TIM_EGR_UG);
  
  TIM_Enable_CEN(TIM8);  
  
  while(1)
  {
    
  }
}

